#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using System.Net;

#endregion
namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{


	[TestFixture]
	public class HL7AL_HL7Interface : BaseTest 
	{
		private HL7Interface _testInterface;
		private DataRow _testInterfaceQCDataRow;
		private bool _propertyChangedEventFired;

		private abstract class TestData
		{
			public const string TestInterfaceName = "CPRS";
			public const string AlternativeTestInterfaceName = "Patient_Merge";
			public const string InterfaceAppplicationID = "OERR";
			public const string VbecsApplicationId = "VBECS";
			public const Int32 PortNumber = 555;
			public static readonly IPAddress IPAddress = IPAddress.Parse( "127.0.0.0" );
			public const string DomainName = "foo.com";
			public const string FacilityID = "589B";
			public const Int32 AckTimeout = 111;
			public const byte ReTransmitAttempts = 33;
			public const byte PurgeSuccessfulMessage = 77;
			public const byte PurgeUnSuccessfulMessage = 88;
			public const string InterfaceAdministratorEmail = "a@b.com";
			public const bool LogEvents = true;
		}

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_propertyChangedEventFired = false;
			_testInterface = new HL7Interface( TestData.TestInterfaceName );
			_testInterface.InterfaceParameterChanged += new EventHandler( OnInterfaceParameterChanged_Handler );

			GetTestInterfaceQCDataRow();
		}

		[TearDown]
		protected void TearDown()
		{
			_testInterface = null;			
		}

		private void GetTestInterfaceQCDataRow()
		{
			if( _testInterfaceQCDataRow == null )
				_testInterfaceQCDataRow = InterfaceControl.GetInterfaceControlParameters( TestData.TestInterfaceName.ToString() );			
		}

		private void OnInterfaceParameterChanged_Handler( object sender, EventArgs e )
		{
			_propertyChangedEventFired = true;
		}

		private void MakeSurePropertyChangedEventFired( string fieldName )
		{
			Assert.IsTrue( _propertyChangedEventFired, String.Concat( "Property changed event was not fired for field ", fieldName ) );
		}

		[Test]
		public void Constructor_Pass()
		{
			Assert.IsNotNull( _testInterface );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Constructor_Fail() {}

		[Test]
		public void GetHL7Interfaces_Pass()
		{
			Assert.IsTrue( HL7Interface.GetHL7Interfaces().Count > 0 );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod )]
		public void GetHL7Interfaces_Fail() {}

		[Test]
		public void InterfaceControlID_Pass()
		{
			Assert.AreEqual( 
				Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceControlId ] ), 
				_testInterface.InterfaceControlId );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void InterfaceControlID_Fail() {}

		[Test]
		public void InterfaceName_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.InterfaceName ] ), 
				_testInterface.InterfaceName );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void InterfaceName_Fail() {}

		[Test]
		public void FieldSeparator_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.FieldSeparator ] ), 
				_testInterface.FieldSeparator );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void FieldSeparator_Fail() {}

		[Test]
		public void EncodingCharacters_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.EncodingCharacters ] ), 
				new StringBuilder().Append( _testInterface.EncodingCharacters ).ToString() );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void EncodingCharacters_Fail() {}

		[Test]
		public void InterfaceApplicationID_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.InterfaceApplicationId ] ), 
				_testInterface.InterfaceApplicationId );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void InterfaceApplicationID_Fail() {}

		[Test]
		public void VbecsApplicationID_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.VbecsApplicationId ] ), 
				_testInterface.VbecsApplicationId );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void VbecsApplicationID_Fail() {}

		[Test]
		public void ProcessingID_Pass()
		{
			Assert.AreEqual( 
				Convert.ToChar( _testInterfaceQCDataRow[ TABLES.InterfaceControl.ProcessingId ] ), 
				_testInterface.ProcessingId );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ProcessingID_Fail() {}

		[Test]
		public void VersionID_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.VersionId ] ), 
				_testInterface.VersionId );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void VersionID_Fail() {}

		[Test]
		public void ApplicationAckType_Pass()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.ApplicationAckType ] ), 
				_testInterface.ApplicationAckType );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ApplicationAckType_Fail() {}

		[Test]
		public void InterfaceIPAddress_Pass_1()
		{
			Assert.IsTrue(
				IPAddress.Parse( Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceIPAddress ] ).Trim() ).Equals(
				_testInterface.InterfaceIPAddress ) );
		}

		[Test]
		public void InterfaceIPAddress_Pass_2()
		{
			_testInterface.InterfaceIPAddress = TestData.IPAddress;
			Assert.AreEqual( TestData.IPAddress, _testInterface.InterfaceIPAddress );
			
			MakeSurePropertyChangedEventFired( "InterfaceIPAddress" );
		}

		[Test]
		public void InterfaceIPAddress_Pass_3()
		{
			_testInterface.InterfaceIPAddress = _testInterface.InterfaceIPAddress;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void InterfaceIPAddress_Fail(){}



		
		[Test]
		public void InterfaceDomainName_Pass_1()
		{
			Assert.IsTrue( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceDomainName ] == System.DBNull.Value &&
				_testInterface.InterfaceDomainName == null );
		}

		[Test]
		public void InterfaceDomainName_Pass_2()
		{
			_testInterface.InterfaceDomainName = TestData.DomainName;
			Assert.AreEqual( TestData.DomainName, _testInterface.InterfaceDomainName );
			
			MakeSurePropertyChangedEventFired( "InterfaceIPAddress" );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void InterfaceDomainName_Fail(){}


		[Test]
		public void InterfacePortNumber_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfacePortNumber ] ), 
				_testInterface.InterfacePortNumber );
		}

		[Test]
		public void InterfacePortNumber_Pass_2()
		{
			_testInterface.InterfacePortNumber = TestData.PortNumber;
			Assert.AreEqual( TestData.PortNumber, _testInterface.InterfacePortNumber );

			MakeSurePropertyChangedEventFired( "InterfacePortNumber" );
		}


		[Test]
		public void InterfacePortNumber_Pass_3()
		{
			_testInterface.InterfacePortNumber = _testInterface.InterfacePortNumber;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void InterfacePortNumber_Fail() {}

		[Test]
		public void InterfaceFacilityID_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceFacilityId ] ), 
				_testInterface.InterfaceFacilityId );
		}

		[Test]
		public void InterfaceFacilityID_Pass_2()
		{
			_testInterface.InterfaceFacilityId = TestData.FacilityID;
			Assert.AreEqual( TestData.FacilityID, _testInterface.InterfaceFacilityId );

			MakeSurePropertyChangedEventFired( "InterfaceFacilityId" );
		}

		[Test]
		public void InterfaceFacilityID_Pass_3()
		{
			_testInterface.InterfaceFacilityId = _testInterface.InterfaceFacilityId;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void InterfaceFacilityID_Fail() {}

		[Test]
		public void VbecsIPAddress_Pass_1()
		{
			System.Net.IPAddress tstValue = _testInterface.VbecsIPAddress;
			Assert.AreEqual( tstValue, _testInterface.VbecsIPAddress );
		}

		[Test]
		public void VbecsIPAddress_Pass_2()
		{
			_testInterface.VbecsIPAddress = TestData.IPAddress;
			Assert.AreEqual( TestData.IPAddress, _testInterface.VbecsIPAddress );
			
			MakeSurePropertyChangedEventFired( "VbecsIPAddress" );
		}

		[Test]
		public void VbecsIPAddress_Pass_3()
		{
			_testInterface.VbecsIPAddress = _testInterface.VbecsIPAddress;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void VbecsIPAddress_Fail(){}

		[Test]
		public void VbecsPortNumber_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.VbecsPortNumber ] ), 
				_testInterface.VbecsPortNumber );
		}

		[Test]
		public void VbecsPortNumber_Pass_2()
		{
			_testInterface.VbecsPortNumber = TestData.PortNumber;
			Assert.AreEqual( TestData.PortNumber, _testInterface.VbecsPortNumber );

			MakeSurePropertyChangedEventFired( "VbecsPortNumber" );
		}

		[Test]
		public void VbecsPortNumber_Pass_3()
		{
			_testInterface.VbecsPortNumber = _testInterface.VbecsPortNumber;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void VbecsPortNumber_Fail() {}

		[Test]
		public void VbecsFacilityID_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.VbecsFacilityId ] ), 
				_testInterface.VbecsFacilityId );
		}

		[Test]
		public void VbecsFacilityID_Pass_2()
		{
			_testInterface.VbecsFacilityId = TestData.FacilityID;
			Assert.AreEqual( TestData.FacilityID, _testInterface.VbecsFacilityId );

			MakeSurePropertyChangedEventFired( "VbecsFacilityId" );
		}

		[Test]
		public void VbecsFacilityID_Pass_3()
		{
			_testInterface.VbecsFacilityId = _testInterface.VbecsFacilityId;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void VbecsFacilityID_Fail() {}

		[Test]
		public void AckTimeout_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.AckTimeout ] ), 
				_testInterface.AckTimeout );
		}

		[Test]
		public void AckTimeout_Pass_2()
		{
			_testInterface.AckTimeout = TestData.AckTimeout;
			Assert.AreEqual( TestData.AckTimeout, _testInterface.AckTimeout );

			MakeSurePropertyChangedEventFired( "AckTimeout" );
		}

		[Test]
		public void AckTimeout_Pass_3()
		{
			_testInterface.AckTimeout = _testInterface.AckTimeout;

			if( _propertyChangedEventFired ) 
				Assert.Fail();

			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void AckTimeout_Fail() {}

		[Test]
		public void ReTransmitAttempts_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToByte( _testInterfaceQCDataRow[ TABLES.InterfaceControl.ReTransmitAttempts ] ), 
				_testInterface.ReTransmitAttempts );
		}

		[Test]
		public void ReTransmitAttempts_Pass_2()
		{
			_testInterface.ReTransmitAttempts = TestData.ReTransmitAttempts;
			Assert.AreEqual( TestData.ReTransmitAttempts, _testInterface.ReTransmitAttempts );

			MakeSurePropertyChangedEventFired( "ReTransmitAttempts" );
		}

		[Test]
		public void ReTransmitAttempts_Pass_3()
		{
			_testInterface.ReTransmitAttempts = _testInterface.ReTransmitAttempts;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ReTransmitAttempts_Fail() {}

		[Test]
		public void PurgeSuccessfulMessage_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToByte( _testInterfaceQCDataRow[ TABLES.InterfaceControl.PurgeSuccessfulMessage ] ), 
				_testInterface.PurgeSuccessfulMessage );
		}

		[Test]
		public void PurgeSuccessfulMessage_Pass_2()
		{
			_testInterface.PurgeSuccessfulMessage = TestData.PurgeSuccessfulMessage;
			Assert.AreEqual( TestData.PurgeSuccessfulMessage, _testInterface.PurgeSuccessfulMessage );

			MakeSurePropertyChangedEventFired( "PurgeSuccessfulMessage" );
		}

		[Test]
		public void PurgeSuccessfulMessage_Pass_3()
		{
			_testInterface.PurgeSuccessfulMessage = _testInterface.PurgeSuccessfulMessage;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void PurgeSuccessfulMessage_Fail() {}

		[Test]
		public void PurgeUnSuccessfulMessage_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToByte( _testInterfaceQCDataRow[ TABLES.InterfaceControl.PurgeUnSuccessfulMessage ] ), 
				_testInterface.PurgeUnSuccessfulMessage );
		}

		[Test]
		public void PurgeUnSuccessfulMessage_Pass_2()
		{
			_testInterface.PurgeUnSuccessfulMessage = TestData.PurgeUnSuccessfulMessage;
			Assert.AreEqual( TestData.PurgeUnSuccessfulMessage, _testInterface.PurgeUnSuccessfulMessage );

			MakeSurePropertyChangedEventFired( "PurgeUnSuccessfulMessage" );
		}
		
		[Test]
		public void PurgeUnSuccessfulMessage_Pass_3()
		{
			_testInterface.PurgeUnSuccessfulMessage = _testInterface.PurgeUnSuccessfulMessage;

			if( _propertyChangedEventFired ) 
				Assert.Fail();
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void PurgeUnSuccessfulMessage_Fail() {}

		[Test]
		public void InterfaceAdministratorEmail_Pass_1()
		{
			Assert.AreEqual( 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceAdministratorName ] ), 
				_testInterface.InterfaceAdministratorEmail );
		}

		[Test]
		public void InterfaceAdministratorEmail_Pass_2()
		{
			_testInterface.InterfaceAdministratorEmail = TestData.InterfaceAdministratorEmail;
			Assert.AreEqual( TestData.InterfaceAdministratorEmail, _testInterface.InterfaceAdministratorEmail );

			MakeSurePropertyChangedEventFired( "InterfaceAdministratorEmail" );
		}

		[Test]
		public void InterfaceAdministratorEmail_Pass_3()
		{
			_testInterface.InterfaceAdministratorEmail = _testInterface.InterfaceAdministratorEmail;

			if( _propertyChangedEventFired ) 
				Assert.Fail();

			Assert.IsTrue(true);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void InterfaceAdministratorEmail_Fail() {}

		[Test]
		public void LogEvent_Pass_1()
		{
			Assert.AreEqual( 
			Convert.ToBoolean( _testInterfaceQCDataRow[ TABLES.InterfaceControl.LogEventsIndicator ] ), 
			_testInterface.LogEvents );
		}

		[Test]
		public void LogEvents_Pass_2()
		{
			bool tstValue = (!_testInterface.LogEvents);

			_testInterface.LogEvents = tstValue;
			Assert.AreEqual( tstValue, _testInterface.LogEvents );

			MakeSurePropertyChangedEventFired( "LogEvents" );
		}

		[Test]
		public void LogEvents_Pass_3()
		{
			_testInterface.LogEvents = _testInterface.LogEvents;

			if( _propertyChangedEventFired ) 
				Assert.Fail();

			Assert.IsTrue(true);

		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void LogEvents_Fail() {}

		[Test]
		public void EOTByte_Pass()
		{
			Assert.IsTrue(HL7Interface.EOTByte == Convert.ToByte( 13 ));
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void EOTByte_Fail()
		{}

		[Test]
		public void SOTByte_Pass()
		{
			Assert.IsTrue(HL7Interface.SOTByte == Convert.ToByte( 11 ));
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void SOTByte_Fail()
		{}

		[Test]
		public void FSByte_Pass()
		{
			Assert.IsTrue(HL7Interface.FSByte == Convert.ToByte( 28 ));
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void FSByte_Fail()
		{}

		[Test]
		public void LoadFromDataRow_Pass()
		{
			_testInterface = new HL7Interface( TestData.AlternativeTestInterfaceName );

			_testInterface.LoadFromDataRow( _testInterfaceQCDataRow );

			Assert.AreEqual( _testInterface.InterfaceControlId,		Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceControlId ] ) );
			Assert.AreEqual( _testInterface.InterfaceName,			Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.InterfaceName ] ) );
			Assert.AreEqual( _testInterface.FieldSeparator,			Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.FieldSeparator ] ) );
			
			Assert.AreEqual( 
				_testInterface.EncodingCharacters.Length, 
				_testInterfaceQCDataRow.IsNull( TABLES.Interface.EncodingCharacters ) ? 0 : Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.EncodingCharacters ] ).ToCharArray().Length );			

			Assert.AreEqual( _testInterface.InterfaceApplicationId,	Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.InterfaceApplicationId ] ) );
			Assert.AreEqual( _testInterface.VbecsApplicationId,	Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.VbecsApplicationId ] ) );			
			Assert.AreEqual( _testInterface.ProcessingId,			Convert.ToChar( _testInterfaceQCDataRow[ TABLES.InterfaceControl.ProcessingId ] ) );
			Assert.AreEqual( _testInterface.VersionId,				Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.VersionId ] ) );
			Assert.AreEqual( _testInterface.ApplicationAckType,		Convert.ToString( _testInterfaceQCDataRow[ TABLES.Interface.ApplicationAckType ] ) );

			Assert.AreEqual( 
				_testInterface.InterfaceIPAddress == null ? string.Empty : _testInterface.InterfaceIPAddress.ToString(), 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceIPAddress ] ).Trim() );

			Assert.AreEqual( _testInterface.InterfacePortNumber,		Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfacePortNumber ] ) );
			Assert.AreEqual( _testInterface.InterfaceFacilityId,		Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceFacilityId ] ) );

			Assert.AreEqual( 
				_testInterface.VbecsIPAddress == null ? string.Empty : _testInterface.VbecsIPAddress.ToString(), 
				Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.VbecsIPAddress ] ).Trim() );

			Assert.AreEqual( _testInterface.VbecsPortNumber,			Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.VbecsPortNumber ] ) );
			Assert.AreEqual( _testInterface.VbecsFacilityId,			Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.VbecsFacilityId ] ) );

			Assert.AreEqual( _testInterface.AckTimeout,					Convert.ToInt32( _testInterfaceQCDataRow[ TABLES.InterfaceControl.AckTimeout ] ) );
			Assert.AreEqual( _testInterface.ReTransmitAttempts,			Convert.ToByte( _testInterfaceQCDataRow[ TABLES.InterfaceControl.ReTransmitAttempts ] ) );
			Assert.AreEqual( _testInterface.PurgeSuccessfulMessage,		Convert.ToByte( _testInterfaceQCDataRow[ TABLES.InterfaceControl.PurgeSuccessfulMessage ] ) );
			Assert.AreEqual( _testInterface.PurgeUnSuccessfulMessage,	Convert.ToByte( _testInterfaceQCDataRow[ TABLES.InterfaceControl.PurgeUnSuccessfulMessage ] ) );
			Assert.AreEqual( _testInterface.InterfaceAdministratorEmail,	Convert.ToString( _testInterfaceQCDataRow[ TABLES.InterfaceControl.InterfaceAdministratorName ] ) );
			Assert.AreEqual( _testInterface.LogEvents,					Convert.ToBoolean( _testInterfaceQCDataRow[ TABLES.InterfaceControl.LogEventsIndicator ] ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void LoadFromDataRow_Fail_1()
		{
			_testInterface.LoadFromDataRow( null );
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void LoadFromDataRow_Fail_2()
		{
			_testInterface.LoadFromDataRow( GetInvalidDataRow() );
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
            DataRow _dr = UnitTestUtil.RunSQLGetDataRow("select top 1 i.InterfaceName , i.FieldSeparator, i.EncodingCharacters, i.InterfaceApplicationId, i.VbecsApplicationId, i.VersionId, i.ApplicationAckType, ic.* from interface i join interfacecontrol ic on i.interfaceid = ic.interfaceid");
			_testInterface.LoadDataRowFromThis( _dr );

			Assert.AreEqual( _dr[ TABLES.Interface.InterfaceName ].ToString(), _testInterface.InterfaceName );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void LoadDataRowFromThis_Fail_1()
		{
			_testInterface.LoadDataRowFromThis( null );
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail_2()
		{
			_testInterface.LoadDataRowFromThis( GetInvalidDataRow() );
		}

		[Test]
		public void ExportAsDataRow_Pass()
		{
			HL7Interface intParms = new HL7Interface("CPRS");
			DataRow dr = intParms.ExportAsDataRow();
			Assert.IsNotNull( dr );
			Assert.AreEqual( dr[Common.VbecsTables.Interface.InterfaceName].ToString(), "CPRS" );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExportAsDataRow_Fail()
		{
			// No Failure conditions apply to this method.
		}

		[Test]
		public void GetInterfaceByApplicationIdentifiers_Pass()
		{
			string interfaceApplicationId = "OERR";
			string vbecsApplicationId = "VBECS";
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(interfaceApplicationId, vbecsApplicationId) );
			//
			interfaceApplicationId = "VAFC PIMS";
			vbecsApplicationId = "VBECS ADT";
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(interfaceApplicationId, vbecsApplicationId) );
			//
			interfaceApplicationId = "MPIF TRIGGER";
			vbecsApplicationId = "VBECS ADT";
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(interfaceApplicationId, vbecsApplicationId) );
			//
			interfaceApplicationId = "WBC";
			vbecsApplicationId = "VBECS";
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(interfaceApplicationId, vbecsApplicationId) );
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetInterfaceByApplicationIdentifiers_Fail_Strings_Empty()
		{
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(string.Empty, string.Empty) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetInterfaceByApplicationIdentifiers_Fail_Null_Interface_App_Id()
		{
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(null, string.Empty) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetInterfaceByApplicationIdentifiers_Fail_Null_Vbecs_App_Id()
		{
			Assert.IsNotNull( HL7Interface.GetInterfaceByApplicationIdentifiers(string.Empty, null) );
		}

		[Test]
		public void GetInterfaceById_Pass()
		{
			HL7Interface tmpObject = HL7Interface.GetInterfaceById(1);
			Assert.IsNotNull( tmpObject );
			Assert.IsTrue( tmpObject.InterfaceControlId == 1);
			//
			tmpObject = HL7Interface.GetInterfaceById(2);
			Assert.IsNotNull( tmpObject );
			Assert.IsTrue( tmpObject.InterfaceControlId == 2);
			//
			tmpObject = HL7Interface.GetInterfaceById(3);
			Assert.IsNotNull( tmpObject );
			Assert.IsTrue( tmpObject.InterfaceControlId == 3);
			//
			tmpObject = HL7Interface.GetInterfaceById(4);
			Assert.IsNotNull( tmpObject );
			Assert.IsTrue( tmpObject.InterfaceControlId == 4);
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetInterfaceById_Fail()
		{
			Assert.IsNull( HL7Interface.GetInterfaceById(-1) );
		}

		/// <summary>
		/// 
		/// </summary>
		/// <returns></returns>
		private DataRow GetInvalidDataRow()
		{
			DataTable _dt = new DataTable();
			_dt.Columns.Add( TABLES.InterfaceControl.InterfaceControlId );

			return _dt.NewRow();
		}

	}
}
#endif
